/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.inventory.personalstorage;

import fr.iglee42.evolvedmekanism.inventory.personalstorage.AbstractTieredPersonalStorageItemInventory;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.ClientSideTieredPersonalStorageInventory;
import fr.iglee42.evolvedmekanism.inventory.personalstorage.TieredPersonalStorageManager;
import fr.iglee42.evolvedmekanism.items.ItemBlockTieredPersonalStorage;
import fr.iglee42.evolvedmekanism.registries.EMContainerTypes;
import java.util.List;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.item.MekanismItemContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TieredPersonalStorageItemContainer
extends MekanismItemContainer {
    private final AbstractTieredPersonalStorageItemInventory itemInventory;

    public TieredPersonalStorageItemContainer(int id, Inventory inv, InteractionHand hand, ItemStack stack, boolean isRemote) {
        super(EMContainerTypes.TIERED_PERSONAL_STORAGE_ITEM, id, inv, hand, stack);
        ItemBlockTieredPersonalStorage item = (ItemBlockTieredPersonalStorage)stack.m_41720_();
        this.itemInventory = !isRemote ? TieredPersonalStorageManager.getInventoryFor(stack) : new ClientSideTieredPersonalStorageInventory(item.getTier());
        super.addSlotsAndOpen();
    }

    protected void addSlotsAndOpen() {
    }

    protected void addSlots() {
        super.addSlots();
        List<IInventorySlot> inventorySlots = this.itemInventory.getInventorySlots(null);
        for (IInventorySlot inventorySlot : inventorySlots) {
            Slot containerSlot = inventorySlot.createContainerSlot();
            if (containerSlot == null) continue;
            this.m_38897_(containerSlot);
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    protected int getInventoryYOffset() {
        int moreRows = ((ItemBlockTieredPersonalStorage)this.getStack().m_41720_()).getTier().rows - 6;
        return 140 + moreRows * 18;
    }

    protected int getInventoryXOffset() {
        return super.getInventoryXOffset() + (((ItemBlockTieredPersonalStorage)this.getStack().m_41720_()).getTier().columns - 9) / 2 * 18;
    }

    protected HotBarSlot createHotBarSlot(@NotNull Inventory inv, int index, int x, int y) {
        if (index == inv.f_35977_ && this.hand == InteractionHand.MAIN_HAND) {
            return new HotBarSlot((Container)inv, index, x, y){

                public boolean m_8010_(@NotNull Player player) {
                    return false;
                }
            };
        }
        return super.createHotBarSlot(inv, index, x, y);
    }

    public void m_150399_(int slotId, int dragType, @NotNull ClickType clickType, @NotNull Player player) {
        if (clickType == ClickType.SWAP) {
            if (this.hand == InteractionHand.OFF_HAND && dragType == 40) {
                return;
            }
            if (this.hand == InteractionHand.MAIN_HAND && dragType >= 0 && dragType < Inventory.m_36059_() && !((HotBarSlot)this.hotBarSlots.get(dragType)).m_8010_(player)) {
                return;
            }
        }
        super.m_150399_(slotId, dragType, clickType, player);
    }

    public ItemStack getStack() {
        return this.stack;
    }
}

